/*
 * Decompiled with CFR 0.152.
 */
package launcher.Fancy;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import launcher.Gameupdater.ProgressBar;
import launcher.Settings;
import launcher.Utils.Defaults;
import launcher.Utils.Logger;
import launcher.Utils.Utils;
import launcher.elements.ControlButton;
import launcher.elements.LaunchButton;
import launcher.elements.LinkButton;
import launcher.elements.MainWindowButtons;
import launcher.listeners.ButtonListener;
import launcher.listeners.PositionListener;

public class MainWindow
extends JFrame {
    private static MainWindow instance;
    public JLabel _BACKGROUND;
    public final MainWindowButtons buttons = new MainWindowButtons();
    public static final Font helvetica13;
    public static final Font helvetica36;
    public static final Font helvetica50;
    private final Font helvetica13b = new Font("Helvetica", 1, 13);
    private final Font silkscreen30 = Utils.getFont("Silkscreen.ttf", 0, 30.0f);
    private final Font silkscreen40 = Utils.getFont("Silkscreen.ttf", 0, 40.0f);
    private final Font silkscreen12 = Utils.getFont("Silkscreen.ttf", 0, 12.0f);
    private final Font helvetica16b = new Font("Helvetica", 1, 16);
    private final Font helvetica12b = new Font("Helvetica", 1, 12);
    public static final Font helvetica20b;
    public static final Font helvetica24b;
    public static final Color yellow;
    public static final Color white;
    public static final Color linkColor;

    public MainWindow() {
        if (Settings.undecoratedWindow) {
            this.setPreferredSize(new Dimension(680, 440));
            this.setMinimumSize(new Dimension(680, 440));
        } else {
            this.setPreferredSize(new Dimension(680, 440));
            this.setMinimumSize(new Dimension(680, 440));
        }
        this.setUndecorated(Settings.undecoratedWindow);
        this.setTitle("Revival RSC Launcher");
        this.setIconImage(Utils.getImage("icon.png").getImage());
        this.setDefaultCloseOperation(3);
        instance = this;
    }

    public static MainWindow get() {
        return instance;
    }

    public void build() {
        JPanel containerPanel = new JPanel(new GridBagLayout());
        this._BACKGROUND = new JLabel(Utils.getImage("background.png"));
        this._BACKGROUND.setBounds(0, 0, 794, 560);
        containerPanel.add(this._BACKGROUND);
        containerPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        containerPanel.setBackground(Color.BLACK);
        this.setContentPane(containerPanel);
        this.defineButtons();
        this.addButtons();
        this.addServerButtons();
        if (Settings.undecoratedWindow) {
            this.addMouseListener(new PositionListener(this));
            this.addMouseMotionListener(new PositionListener(this));
        }
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                e.getComponent().setPreferredSize(new Dimension(e.getComponent().getWidth(), e.getComponent().getHeight()));
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public void defineButtons() {
        int control_button_width = 30;
        int control_button_height = 30;
        this.buttons.main_minimize = new ControlButton(1, 600, 10, control_button_width, control_button_height);
        this.buttons.main_close = new ControlButton(2, 640, 10, control_button_width, control_button_height);
        this.buttons.delete_cache = new ControlButton(3, 575, 415, 100, 20);
        this.buttons.version_number = new JLabel("<html>v:" + String.format("%8.6f", Defaults._CURRENT_VERSION) + "</html>");
        this.buttons.version_number.setFont(this.silkscreen12);
        this.buttons.version_number.setOpaque(true);
        this.buttons.version_number.setBackground(Color.decode("#191919"));
        this.buttons.version_number.setHorizontalAlignment(0);
        this.buttons.version_number.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.buttons.version_number.setBounds(4, 415, 100, 20);
        this.buttons.version_number.setForeground(Color.decode("#6D6D6D"));
    }

    public void addButtons() {
        ProgressBar.setVisible(true);
        this._BACKGROUND = this.buttons.addAll(this._BACKGROUND);
        this._BACKGROUND.add(this.buttons.version_number);
    }

    private JLabel updateTextBounds(JLabel jlabel) {
        Rectangle oldBounds = jlabel.getBounds();
        jlabel.setBounds(oldBounds.x, oldBounds.y, jlabel.getPreferredSize().width, oldBounds.height);
        return jlabel;
    }

    public void addServerButtons() {
        int launch_button_width = 100;
        int launch_button_height = 100;
        int kale_x = 410;
        int openPk_x = 410;
        int coleslaw_x = 410;
        int cabbage_x = 410;
        int launch_button_row1_y = 75;
        int launch_button_row2_y = launch_button_row1_y + 100 + 10;
        int launch_button_row3_y = launch_button_row2_y + 100 + 10;
        int launch_button_row2_bots_y = launch_button_row2_y;
        this.buttons.openrsc_logo = new LinkButton("revival-logo", new Rectangle(118, launch_button_row1_y, 445, 110));
        this._BACKGROUND.add(this.buttons.openrsc_logo);
        int x = cabbage_x + 110;
        int y = launch_button_row2_y;
        final JLabel subline = new JLabel("A Runescape Classic Server");
        subline.setFont(this.silkscreen30);
        subline.setForeground(Color.decode("#FFD400"));
        this._BACKGROUND.add(subline);
        final JButton play = new JButton("PLAY");
        play.setFont(this.silkscreen40);
        play.setForeground(Color.decode("#010101"));
        play.setBackground(Color.decode("#FFD400"));
        play.setOpaque(true);
        play.setContentAreaFilled(true);
        play.setBorder(BorderFactory.createEmptyBorder());
        play.setFocusPainted(false);
        play.setActionCommand("cabbage");
        play.addActionListener(new ButtonListener());
        play.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ MainWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                play.setBackground(Color.decode("#FFE14A"));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                play.setBackground(Color.decode("#FFD400"));
            }
        });
        play.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(6, 12, 12, 12), play.getBorder()));
        this._BACKGROUND.add(play);
        this._BACKGROUND.setComponentZOrder(play, 0);
        this._BACKGROUND.addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ MainWindow this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void componentResized(ComponentEvent e) {
                Rectangle logoBounds = this.this$0.buttons.openrsc_logo.getBounds();
                Dimension subSize = subline.getPreferredSize();
                int subX = logoBounds.x + (logoBounds.width - subSize.width) / 2;
                int subY = logoBounds.y + logoBounds.height;
                subline.setBounds(subX, subY, subSize.width, subSize.height);
                int btnW = 180;
                int btnH = 65;
                int playX = (this.this$0._BACKGROUND.getWidth() - btnW) / 2;
                int playY = subY + subSize.height + 50;
                play.setBounds(playX, playY, btnW, btnH);
            }
        });
        this._BACKGROUND.revalidate();
        this._BACKGROUND.repaint();
    }

    private void addLinkMouseListener(JButton jlabel, Color color, String actionCommand) {
        this.addLinkMouseListener(jlabel, null, null, color, actionCommand);
    }

    private void addLinkMouseListener(final JButton primary, final JButton secondary, final LaunchButton ternary, final Color color, String actionCommand) {
        MouseListener bigMouseListener = new MouseListener(){
            final Icon normal;
            final Icon rollover;
            final /* synthetic */ MainWindow this$0;
            {
                this.this$0 = this$0;
                this.normal = null == ternary ? null : ternary.getIcon();
                this.rollover = null == ternary ? null : ternary.getRolloverIcon();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                primary.setLocation(primary.getX(), primary.getY() + 1);
                if (null != secondary) {
                    secondary.setLocation(secondary.getX(), secondary.getY() + 1);
                }
                if (null != ternary) {
                    ternary.setLocation(ternary.getX(), ternary.getY() + 1);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                primary.setLocation(primary.getX(), primary.getY() - 1);
                if (null != secondary) {
                    secondary.setLocation(secondary.getX(), secondary.getY() - 1);
                }
                if (null != ternary) {
                    ternary.setLocation(ternary.getX(), ternary.getY() - 1);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                primary.setForeground(color.brighter());
                if (null != secondary) {
                    secondary.setForeground(color.brighter());
                }
                if (null != ternary) {
                    ternary.setIcon(this.rollover);
                }
                this.this$0.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                primary.setForeground(color);
                if (null != secondary) {
                    secondary.setForeground(color);
                }
                if (null != ternary) {
                    ternary.setIcon(this.normal);
                }
                this.this$0.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        primary.addMouseListener(bigMouseListener);
        primary.setActionCommand(actionCommand);
        primary.addActionListener(new ButtonListener());
        if (null != secondary) {
            secondary.addMouseListener(bigMouseListener);
            secondary.setActionCommand(actionCommand);
            secondary.addActionListener(new ButtonListener());
        }
        if (null != ternary) {
            ternary.addMouseListener(bigMouseListener);
        }
    }

    private JLabel defineClientLogo(LaunchButton logo) {
        return this.defineClientLogo(logo, null);
    }

    public JLabel defineClientLogo(LaunchButton logo, String preferredClient) {
        String server = logo.getActionCommand();
        int x = logo.getX() + 68;
        int y = logo.getY() + 68;
        if (null == preferredClient) {
            Logger.Error("No client defined for server " + server);
            preferredClient = "notdefined";
        }
        Icon icon = null;
        JLabel clientLogo = new JLabel(icon);
        clientLogo.setBounds(x, y, 32, 32);
        return clientLogo;
    }

    private JLabel drawString(String text, int x, int y, Font font, Color color, boolean add) {
        JLabel a = new JLabel(text);
        a.setFont(font);
        a.setBounds(x, y, a.getPreferredSize().width, a.getFontMetrics(font).getHeight());
        a.setForeground(color);
        if (add) {
            this._BACKGROUND.add(a);
        }
        return a;
    }

    public JButton makeButton(String text, int x, int y, Font font, Color color, boolean add) {
        JButton a = new JButton(text);
        a.setFont(font);
        a.setBorder(new EmptyBorder(0, 0, 0, 0));
        a.setBounds(x, y, a.getPreferredSize().width, a.getFontMetrics(font).getHeight());
        a.setForeground(color);
        a.setBorderPainted(false);
        a.setContentAreaFilled(false);
        if (add) {
            this._BACKGROUND.add(a);
        }
        return a;
    }

    static {
        helvetica13 = new Font("Helvetica", 0, 13);
        helvetica36 = new Font("Helvetica", 0, 36);
        helvetica50 = new Font("Helvetica", 0, 50);
        helvetica20b = new Font("Helvetica", 1, 20);
        helvetica24b = new Font("Helvetica", 1, 24);
        yellow = new Color(255, 200, 0);
        white = new Color(255, 255, 255);
        linkColor = new Color(0, 180, 0);
    }
}

