/*
 * Decompiled with CFR 0.152.
 */
package launcher.Gameupdater;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import launcher.Gameupdater.Downloader;
import launcher.Gameupdater.ProgressBar;
import launcher.Main;
import launcher.Utils.Logger;

public class ClientDownloader {
    private static final String PROPERTIES_FILE = Main.configFileLocation + File.separator + "client_versions.properties";

    public static void downloadOrUpdate(File gamePath, String fileName, String url, String versionStringVarName) {
        Downloader.currently_updating = true;
        ProgressBar.initProgressBar();
        ProgressBar.setDownloadProgress("Checking for updates", 100.0f);
        new Thread(() -> {
            try {
                double currentVersion = ClientDownloader.getLocalVersion(versionStringVarName);
                Logger.Info("Checking if local version " + currentVersion + " is up to date with remote version " + ClientDownloader.getRemoteVersionNumber(versionStringVarName));
                if (ClientDownloader.isUpdateAvailable(currentVersion, versionStringVarName)) {
                    Logger.Info("We are not up to date, updating..");
                    ClientDownloader.createDirectory(gamePath);
                    ClientDownloader.downloadFile(gamePath, fileName, url);
                    ClientDownloader.unZipUpdate(gamePath + File.separator + fileName, gamePath.toString());
                    ClientDownloader.updateVersion(versionStringVarName, ClientDownloader.getRemoteVersionNumber(versionStringVarName));
                }
                ProgressBar.setDownloadProgress("Done", 100.0f);
            }
            catch (Exception error) {
                Logger.Warn("Update error: " + error.getMessage());
                error.printStackTrace();
            }
            finally {
                Downloader.currently_updating = false;
            }
        }).start();
    }

    private static double getLocalVersion(String versionStringVarName) {
        double d;
        FileInputStream input = new FileInputStream(PROPERTIES_FILE);
        try {
            Properties prop = new Properties();
            prop.load(input);
            Logger.Info("Found version " + prop.getProperty(versionStringVarName, "0.0") + " for " + versionStringVarName);
            d = Double.parseDouble(prop.getProperty(versionStringVarName, "0.0"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                Logger.Warn("Unable to read version: " + ex.getMessage());
                return 0.0;
            }
        }
        ((InputStream)input).close();
        return d;
    }

    public static Double getRemoteVersionNumber(String versionStringVarName) {
        try {
            String line;
            double extraVersion = 0.0;
            URL updateURL = new URL("https://gitlab.com/spyntax/web-launcher-updates/-/raw/main/version.txt");
            URLConnection connection = updateURL.openConnection();
            connection.setConnectTimeout(3000);
            connection.setReadTimeout(3000);
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                if (!line.contains(versionStringVarName)) continue;
                extraVersion = Double.parseDouble(line.substring(line.indexOf(61) + 1, line.indexOf(59)));
                Logger.Info(versionStringVarName + " remote version: " + extraVersion);
                break;
            }
            in.close();
            return extraVersion;
        }
        catch (Exception e) {
            Logger.Error("Error checking latest version of " + versionStringVarName);
            e.printStackTrace();
            return 0.0;
        }
    }

    private static void updateVersion(String versionStringVarName, double newVersion) {
        Properties prop = new Properties();
        try (FileInputStream input = new FileInputStream(PROPERTIES_FILE);){
            prop.load(input);
        }
        catch (IOException io) {
            Logger.Warn("Unable to load existing versions: " + io.getMessage());
        }
        try (FileOutputStream output = new FileOutputStream(PROPERTIES_FILE);){
            prop.setProperty(versionStringVarName, Double.toString(newVersion));
            prop.store(output, null);
        }
        catch (IOException io) {
            Logger.Warn("Unable to update version: " + io.getMessage());
        }
    }

    private static void createDirectory(File gamePath) throws IOException {
        if (gamePath.getParentFile() != null) {
            Files.createDirectories(gamePath.toPath(), new FileAttribute[0]);
        }
    }

    private static void downloadFile(File gamePath, String fileName, String url) throws IOException {
        URLConnection connection = new URL(url).openConnection();
        int fileSize = connection.getContentLength();
        try (BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
             FileOutputStream fileOS = new FileOutputStream(gamePath + File.separator + fileName);){
            int byteContent;
            byte[] data = new byte[1024];
            int totalRead = 0;
            while ((byteContent = inputStream.read(data, 0, 1024)) != -1) {
                fileOS.write(data, 0, byteContent);
                ProgressBar.setDownloadProgress("Downloading " + fileName, (float)(totalRead += byteContent) / (float)fileSize * 100.0f);
            }
        }
    }

    private static void unZipUpdate(String pathToUpdateZip, String destinationPath) {
        try (ZipInputStream inZip = new ZipInputStream(new FileInputStream(pathToUpdateZip));){
            ZipEntry inZipEntry;
            int unzipCount = 0;
            while ((inZipEntry = inZip.getNextEntry()) != null) {
                File unZippedFile = new File(destinationPath, inZipEntry.getName());
                if (inZipEntry.isDirectory()) {
                    unZippedFile.mkdirs();
                } else {
                    new File(unZippedFile.getParent()).mkdirs();
                    try (FileOutputStream unZippedFileOutputStream = new FileOutputStream(unZippedFile);){
                        int length;
                        byte[] byteBuffer = new byte[1024];
                        while ((length = inZip.read(byteBuffer)) > 0) {
                            unZippedFileOutputStream.write(byteBuffer, 0, length);
                        }
                    }
                }
                ProgressBar.setDownloadProgress("Unzipping: " + unZippedFile.getName(), ++unzipCount * 5);
                inZip.closeEntry();
            }
            Logger.Info("Finished Unzipping");
        }
        catch (IOException e) {
            Logger.Warn("Unzipping error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static boolean isUpdateAvailable(Double currentVersion, String versionStringVarName) {
        return currentVersion < ClientDownloader.getRemoteVersionNumber(versionStringVarName);
    }
}

