/*
 * Decompiled with CFR 0.152.
 */
package launcher.Gameupdater;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import launcher.Gameupdater.Md5Handler;
import launcher.Gameupdater.ProgressBar;
import launcher.Main;
import launcher.Utils.Logger;

public class Downloader
implements Runnable {
    private final ArrayList<String> _EXCLUDED_FILES = new ArrayList();
    private final ArrayList<String> _REFUSE_UPDATE = new ArrayList();
    private final String _GAMEFOLDER;
    public static boolean offline_start = false;
    public static boolean currently_updating = false;
    private List<File> FILE_LIST = new ArrayList<File>();

    public Downloader(String gameFolder, List<File> fileList) {
        this._EXCLUDED_FILES.add("MD5.SUM");
        this._EXCLUDED_FILES.add("android_version.txt");
        this._EXCLUDED_FILES.add("android_version_pk.txt");
        this._EXCLUDED_FILES.add("openrsc.apk");
        this._EXCLUDED_FILES.add("openpk.apk");
        this._EXCLUDED_FILES.add("credentials.txt");
        this._EXCLUDED_FILES.add("config.txt");
        this._EXCLUDED_FILES.add("discord_inuse.txt");
        this._EXCLUDED_FILES.add("uid.dat");
        this._EXCLUDED_FILES.add("OpenRSC.jar");
        this._EXCLUDED_FILES.add("ip.txt");
        this._EXCLUDED_FILES.add("port.txt");
        this._EXCLUDED_FILES.add("Revival_Client_Dev.jar");
        this._GAMEFOLDER = gameFolder;
        this.FILE_LIST = fileList;
    }

    public void initOpenRSCClientUpdate() {
        System.out.println("_GAME_FILES_SERVER = [https://gitlab.com/spyntax/web-launcher-updates/-/raw/main/]");
        System.out.println("_MD5_TABLE_FILENAME = [MD5.SUM]");
        currently_updating = true;
        ProgressBar.initProgressBar();
        try {
            ProgressBar.setDownloadProgress("Checking for updates", 100.0f);
            File currentMd5Table = new File(this._GAMEFOLDER + File.separator + "MD5.SUM");
            if (currentMd5Table.exists()) {
                currentMd5Table.delete();
            }
            this.downloadOne(new File("MD5.SUM"));
            Md5Handler localCache = new Md5Handler(currentMd5Table.getParentFile(), this._GAMEFOLDER);
            Md5Handler remoteCache = new Md5Handler(currentMd5Table, this._GAMEFOLDER);
            ArrayList<File> downloadList = new ArrayList<File>();
            for (Md5Handler.Entry entry : remoteCache.entries) {
                if (this._EXCLUDED_FILES.contains(entry.getRef().getName())) continue;
                File parent = entry.getRef().getParentFile();
                if (parent != null) {
                    parent.mkdirs();
                }
                entry.getRef().getParentFile().mkdirs();
                String localSum = localCache.getRefSum(entry.getRef());
                if (localSum != null && (this._REFUSE_UPDATE.contains(entry.getRef().getName()) || localSum.equalsIgnoreCase(entry.getSum()))) continue;
                downloadList.add(entry.getDownloadRef());
            }
            this.download(downloadList);
        }
        catch (Exception error) {
            Logger.Error("Unable to load checksums.");
            error.printStackTrace();
        }
    }

    private void download(List<File> fileList) {
        Thread t = new Thread(new Downloader(Main.configFileLocation, fileList));
        t.start();
    }

    private void downloadOne(File file) {
        try {
            String filename = file.toString().replaceAll("\\\\", "/");
            String completeFileUrl = "https://gitlab.com/spyntax/web-launcher-updates/-/raw/main/" + filename;
            Logger.Info("Downloading: " + completeFileUrl);
            URLConnection connection = new URL(completeFileUrl).openConnection();
            String description = file.getName();
            long fileSize = connection.getContentLength();
            try (BufferedInputStream inputStream = new BufferedInputStream(new URL(completeFileUrl).openStream());
                 FileOutputStream fileOS = new FileOutputStream(this._GAMEFOLDER + File.separator + filename);){
                int byteContent;
                byte[] data = new byte[1024];
                double totalRead = 0.0;
                while ((byteContent = inputStream.read(data, 0, 1024)) != -1) {
                    fileOS.write(data, 0, byteContent);
                    float percent = (float)((totalRead += (double)byteContent) / (double)fileSize) * 100.0f;
                    ProgressBar.setDownloadProgress(description, percent);
                }
            }
            catch (UnknownHostException uhe) {
                offline_start = true;
            }
            catch (Exception error) {
                error.printStackTrace();
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    @Override
    public void run() {
        Logger.Info(this.FILE_LIST.size() + " files to download");
        for (File file : this.FILE_LIST) {
            this.downloadOne(file);
        }
        ProgressBar.setDownloadProgress("Your game client is up to date", 200.0f);
        currently_updating = false;
    }
}

