/*
 * Decompiled with CFR 0.152.
 */
package launcher.Gameupdater;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.plaf.basic.BasicProgressBarUI;
import launcher.Fancy.MainWindow;
import launcher.Utils.Utils;

public class ProgressBar {
    private static JProgressBar BAR;
    public static final String doneText = "Your game client is up to date";
    public static final float donePercent = 200.0f;

    public static void setVisible(boolean visible) {
        if (BAR != null) {
            BAR.setVisible(visible);
        }
    }

    public static void initProgressBar() {
        boolean needsRemove = true;
        if (BAR == null) {
            BAR = new JProgressBar(0, 100);
            BAR.setBounds(110, 415, 460, 20);
            Font silkscreen20 = Utils.getFont("Silkscreen.ttf", 0, 12.0f);
            if (silkscreen20 != null) {
                BAR.setFont(silkscreen20);
            }
            BAR.setUI(new BasicProgressBarUI(){
                private final Color textColor = Color.decode("#6D6D6D");

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void paintDeterminate(Graphics g, JComponent c) {
                    Graphics2D g2 = (Graphics2D)g.create();
                    try {
                        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        Insets in = this.progressBar.getInsets();
                        int w = this.progressBar.getWidth() - (in.left + in.right);
                        int h = this.progressBar.getHeight() - (in.top + in.bottom);
                        g2.setColor(this.progressBar.getBackground());
                        g2.fillRect(in.left, in.top, w, h);
                        int amount = this.getAmountFull(in, w, h);
                        int extra = h / 2;
                        int fillY = in.top - extra / 2;
                        int fillH = h + extra;
                        g2.setColor(this.progressBar.getForeground());
                        g2.fillRect(in.left, fillY, amount, fillH);
                        String text = this.progressBar.getString();
                        if (text != null) {
                            g2.setFont(this.progressBar.getFont());
                            FontMetrics fm = g2.getFontMetrics();
                            int textWidth = fm.stringWidth(text);
                            int textX = in.left + (w - textWidth) / 2;
                            int textY = fillY + (fillH - fm.getHeight()) / 2 + fm.getAscent();
                            g2.setColor(this.textColor);
                            g2.drawString(text, textX, textY);
                        }
                    }
                    finally {
                        g2.dispose();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void paintIndeterminate(Graphics g, JComponent c) {
                    Graphics2D g2 = (Graphics2D)g.create();
                    try {
                        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        Insets in = this.progressBar.getInsets();
                        int w = this.progressBar.getWidth() - (in.left + in.right);
                        int h = this.progressBar.getHeight() - (in.top + in.bottom);
                        g2.setColor(this.progressBar.getBackground());
                        g2.fillRect(in.left, in.top, w, h);
                        Rectangle track = new Rectangle(in.left, in.top, w, h);
                        Rectangle box = this.getBox(track);
                        int extra = h / 2;
                        int fillY = in.top - extra / 2;
                        int fillH = h + extra;
                        g2.setColor(this.progressBar.getForeground());
                        g2.fillRect(box.x, fillY, box.width, fillH);
                        String text = this.progressBar.getString();
                        if (text != null) {
                            g2.setFont(this.progressBar.getFont());
                            FontMetrics fm = g2.getFontMetrics();
                            int textWidth = fm.stringWidth(text);
                            int textX = in.left + (w - textWidth) / 2;
                            int textY = fillY + (fillH - fm.getHeight()) / 2 + fm.getAscent();
                            g2.setColor(this.textColor);
                            g2.drawString(text, textX, textY);
                        }
                    }
                    finally {
                        g2.dispose();
                    }
                }
            });
            needsRemove = false;
        }
        BAR.setBackground(Color.decode("#2F2F2F"));
        BAR.setForeground(Color.decode("#191919"));
        BAR.setOpaque(true);
        BAR.setStringPainted(true);
        BAR.setBorderPainted(false);
        BAR.setVisible(true);
        if (needsRemove) {
            MainWindow.get()._BACKGROUND.remove(BAR);
        }
        MainWindow.get()._BACKGROUND.add(BAR);
    }

    public static void setDownloadProgress(String status, float percent) {
        if (percent >= 100.0f) {
            percent = 100.0f;
        }
        BAR.setForeground(Color.decode("#191919"));
        BAR.setValue((int)percent);
        if (percent == 200.0f) {
            BAR.setString(doneText);
        } else {
            BAR.setString(status);
        }
        BAR.repaint();
    }
}

