/*
 * Decompiled with CFR 0.152.
 */
package launcher;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.CodeSource;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import launcher.Fancy.MainWindow;
import launcher.Gameupdater.ClientUpdater;
import launcher.Main;
import launcher.Settings;
import launcher.Utils.Defaults;
import launcher.Utils.Logger;

public class Launcher
extends Component {
    public static ImageIcon icon;
    private JProgressBar m_progressBar;
    public static ClientUpdater updater;

    public static void main(String[] args) {
        String path;
        double ver = Defaults._CURRENT_VERSION;
        try {
            CodeSource src = Main.class.getProtectionDomain().getCodeSource();
            path = Paths.get(src.getLocation().toURI()).toString();
        }
        catch (Exception e) {
            path = "\u2039could not resolve\u203a " + e.getMessage();
        }
        JOptionPane.showMessageDialog(null, "Startup debug:\n  Code version = " + ver + "\n  JAR path      = " + path, "Launcher Debug", 1);
        new Launcher().initializeLauncher();
    }

    public void initializeLauncher() {
        Settings.loadSettings();
        this.m_progressBar = new JProgressBar();
        if (Main.disabledUpdate) {
            Settings.autoUpdate = false;
            Settings.saveSettings();
        } else if (Settings.firstRun) {
            int response = JOptionPane.showConfirmDialog(this, "Would you like to enable automatic launcher updates?\n", "Revival RSC", 0, 1, icon);
            if (response == 0 || response == -1) {
                Settings.autoUpdate = true;
                JOptionPane.showMessageDialog(this, "Nice! Revival RSC will check for updates on each launch.", "Revival RSC", 1, icon);
            } else {
                Settings.autoUpdate = false;
                JOptionPane.showMessageDialog(this, "No problem \u2013 we won't automatically update your launcher.\n\nYou will not get notified when new releases are available.\nTo update the launcher, you will need to manually\ndownload the latest Revival RSC Launcher from our website.", "Revival RSC", 1, icon);
            }
            Settings.firstRun = false;
            Logger.Info("First-run prompt completed; autoUpdate=" + Settings.autoUpdate);
            Settings.saveSettings();
        }
        if (Settings.autoUpdate) {
            this.setStatus("Checking for updates...");
            double latestVersion = Launcher.fetchLatestVersionNumber();
            Logger.Info("Local version    : " + Defaults._CURRENT_VERSION);
            Logger.Info("Remote version   : " + latestVersion);
            if (Defaults._CURRENT_VERSION < latestVersion) {
                this.setStatus("Launcher update is available");
                int response = JOptionPane.showConfirmDialog(this, "A launcher update is available!\n\nLatest: " + String.format("%8.6f", latestVersion) + "\nInstalled: " + String.format("%8.6f", Defaults._CURRENT_VERSION) + "\n\nWould you like to update?", "Revival RSC", 0, 1, icon);
                if (response == 0) {
                    if (this.updateJar()) {
                        JOptionPane.showMessageDialog(this, "Please visit revivalrsc.gg to download the new launcher\n\nIf you'd rather do this later, re-open the launcher and click 'Later'", "Revival RSC", 1, icon);
                        System.exit(0);
                    } else {
                        response = JOptionPane.showConfirmDialog(this, "The launcher has failed to update, please try again.\n\nWould you like to continue without updating?", "Revival RSC", 0, 0, icon);
                        if (response == 1 || response == -1) {
                            System.exit(0);
                        }
                    }
                }
            }
        }
        MainWindow frame = new MainWindow();
        frame.build();
        updater = new ClientUpdater(Main.configFileLocation);
        updater.updateOpenRSCClient();
    }

    public static Double fetchLatestVersionNumber() {
        try {
            String line;
            double currentVersion = 0.0;
            URL updateURL = new URL("https://gitlab.com/spyntax/web-launcher-updates/-/raw/main/version.txt");
            URLConnection connection = updateURL.openConnection();
            connection.setConnectTimeout(3000);
            connection.setReadTimeout(3000);
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                if (!(line = line.trim()).matches("^\\d+\\.\\d+$")) continue;
                currentVersion = Double.parseDouble(line);
                Logger.Info("Remote version fetched: " + currentVersion);
                break;
            }
            in.close();
            return currentVersion;
        }
        catch (Exception e) {
            Logger.Error("Error checking latest version");
            return Defaults._CURRENT_VERSION;
        }
    }

    public boolean updateJar() {
        Path jarPath;
        byte[] data;
        this.setStatus("Starting update...");
        this.setProgress(0, 1);
        try {
            URL url = new URL("https://gitlab.com/spyntax/web-launcher-updates/-/raw/main/RevivalLauncher.jar");
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            int size = conn.getContentLength();
            data = new byte[size];
            try (InputStream in = conn.getInputStream();){
                int read;
                int offset = 0;
                while ((read = in.read(data, offset, size - offset)) != -1) {
                    this.setStatus("Downloading (" + (offset += read) / 1024 + "KiB / " + size / 1024 + "KiB)");
                    this.setProgress(offset, size);
                }
                if (offset != size) {
                    throw new IOException("Only got " + offset + " of " + size + " bytes");
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Download failed:\n" + ex.getClass().getSimpleName() + ": " + ex.getMessage(), "Update Error", 0);
            return false;
        }
        try {
            CodeSource src = Launcher.class.getProtectionDomain().getCodeSource();
            jarPath = Paths.get(src.getLocation().toURI());
            JOptionPane.showMessageDialog(null, "This will overwrite:\n" + jarPath.toString(), "Debug", 1);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Could not find the file to overwrite:\n" + ex.getClass().getSimpleName() + ": " + ex.getMessage(), "Update Error", 0);
            return false;
        }
        try {
            Files.write(jarPath, data, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Write failed:\n" + ex.getClass().getSimpleName() + ": " + ex.getMessage(), "Update Error", 0);
            return false;
        }
        double newVer = Launcher.fetchLatestVersionNumber();
        JOptionPane.showMessageDialog(null, "Launcher updated to v" + String.format("%8.6f", newVer) + ". Please close and relaunch.", "Update Complete", 1);
        System.exit(0);
        return true;
    }

    public void setProgress(final int value, final int total) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ Launcher this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (total == 0) {
                    this.this$0.m_progressBar.setValue(0);
                    return;
                }
                this.this$0.m_progressBar.setValue(value * 100 / total);
            }
        });
    }

    public void error(String text) {
        this.setStatus("Error: " + text);
        try {
            Thread.sleep(5000L);
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setStatus(final String text) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ Launcher this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.m_progressBar.setString(text);
            }
        });
    }

    static {
        URL url = Launcher.class.getResource("/data/images/update-icon.png");
        if (url != null) {
            icon = new ImageIcon(url);
        } else {
            System.err.println("\u26a0\ufe0f icon.png not found on classpath!");
        }
    }
}

