/*
 * Decompiled with CFR 0.152.
 */
package launcher;

import java.io.File;
import launcher.Launcher;
import launcher.Utils.Utils;

public class Main {
    public static String configFileLocation = "Cache";
    public static String SPRITEPACK_DIR = configFileLocation + File.separator + "video" + File.separator + "spritepacks";
    public static boolean disabledUpdate = false;

    public static void main(String[] args) {
        Main.handleArgs(args);
        Launcher mainLauncher = new Launcher();
        mainLauncher.initializeLauncher();
    }

    public static void handleArgs(String[] args) {
        String helpMessage = "Help for the RSC launcher:\n\t--help, -h displays this help message\n\t--dir [loc], -d [loc] changes the cache directory location\n\t--no-update, -n Disables Launcher autoupdate feature and prompt\nExample:\njava -jar OpenRSC.jar -d /home/foo/.local/openrsc";
        int argIndex = 0;
        while (argIndex < args.length) {
            String arg = args[argIndex];
            if (arg.equals("--help") || arg.equals("-h")) {
                System.out.println(helpMessage);
                System.exit(0);
                continue;
            }
            if (arg.equals("--dir") || arg.equals("-d")) {
                if (argIndex + 1 < args.length) {
                    String path = args[argIndex + 1];
                    if (Utils.isValidPath(path)) {
                        configFileLocation = Utils.getCanonicalPath(path);
                        SPRITEPACK_DIR = configFileLocation + File.separator + "video" + File.separator + "spritepacks";
                        argIndex += 2;
                        continue;
                    }
                    System.out.println("Error: please provide a valid path.\nUsage: java -jar OpenRSC.jar -d /path/to/cache/folder");
                    System.exit(1);
                    continue;
                }
                System.out.println("Error: no path specified.\nUsage: java -jar OpenRSC.jar -d /path/to/cache/folder");
                System.exit(1);
                continue;
            }
            if (arg.equals("--no-update") || arg.equals("-n")) {
                disabledUpdate = true;
                ++argIndex;
                continue;
            }
            System.out.println("Unrecognized modifier.\nUse -h for help.");
            System.exit(1);
        }
    }
}

