/*
 * Decompiled with CFR 0.152.
 */
package launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import launcher.Main;
import launcher.Utils.Logger;

public class Settings {
    public static final String RSCPLUS = "rscplus";
    public static final String WINRUNE = "winrune";
    public static final String OPENRSC = "openrsc";
    public static final String MUD38 = "mudclient38";
    public static final String IDLERSC = "idlersc";
    public static final String WEBCLIENT = "webclient";
    public static final String APOSBOT = "aposbot";
    public static final String RSCTIMES = "rsctimes";
    public static boolean showBotButtons = false;
    public static boolean firstRun = true;
    public static boolean autoUpdate = true;
    public static boolean showPrerelease = false;
    public static boolean undecoratedWindow;
    public static boolean undecoratedWindowSave;
    public static int logVerbosity;
    public static String preferredClientPreservation;
    public static String preferredClientCabbage;
    public static String preferredClient2001scape;
    public static String preferredClientKale;
    public static String preferredClientOpenpk;
    public static String preferredClientUranium;
    public static String preferredClientColeslaw;
    private static final String showBotButtonsKey = "show_bot_buttons";
    private static final String autoUpdateKey = "auto_update";
    private static final String firstRunKey = "first_run";
    private static final String undecoratedWindowKey = "undecorated_window";
    private static final String showPrereleaseKey = "show_prerelease_servers";
    private static final String preferredClientPreservationKey = "preferred_client_preservation";
    private static final String preferredClientCabbageKey = "preferred_client_cabbage";
    private static final String preferredClient2001scapeKey = "preferred_client_2001scape";
    private static final String preferredClientKaleKey = "preferred_client_kale";
    private static final String preferredClientOpenpkKey = "preferred_client_openpk";
    private static final String preferredClientUraniumKey = "preferred_client_uranium";
    private static final String preferredClientColeslawKey = "preferred_client_coleslaw";

    static void loadSettings() {
        Properties props = new Properties();
        try {
            File configFile = new File(Main.configFileLocation + "/launcherSettings.conf");
            if (configFile.isDirectory()) {
                Logger.Error("launcherSettings.conf is a directory, not a file!");
                return;
            }
            if (!configFile.exists()) {
                Logger.Info("Creating settings for first launch at " + Main.configFileLocation + "/launcherSettings.conf");
                Settings.saveSettings();
                return;
            }
            FileInputStream in = new FileInputStream(Main.configFileLocation + "/launcherSettings.conf");
            props.load(in);
            in.close();
            showBotButtons = Settings.getPropBoolean(props, showBotButtonsKey, showBotButtons);
            autoUpdate = Settings.getPropBoolean(props, autoUpdateKey, autoUpdate);
            firstRun = Settings.getPropBoolean(props, firstRunKey, firstRun);
            undecoratedWindowSave = undecoratedWindow = Settings.getPropBoolean(props, undecoratedWindowKey, undecoratedWindow);
            showPrerelease = Settings.getPropBoolean(props, showPrereleaseKey, showPrerelease);
            preferredClientPreservation = Settings.getPropString(props, preferredClientPreservationKey, preferredClientPreservation);
            preferredClientCabbage = Settings.getPropString(props, preferredClientCabbageKey, preferredClientCabbage);
            preferredClient2001scape = Settings.getPropString(props, preferredClient2001scapeKey, preferredClient2001scape);
            preferredClientKale = Settings.getPropString(props, preferredClientKaleKey, preferredClientKale);
            preferredClientOpenpk = Settings.getPropString(props, preferredClientOpenpkKey, preferredClientOpenpk);
            preferredClientUranium = Settings.getPropString(props, preferredClientUraniumKey, preferredClientUranium);
            preferredClientColeslaw = Settings.getPropString(props, preferredClientColeslawKey, preferredClientColeslaw);
        }
        catch (Exception e) {
            Logger.Warn("Warning: Error loading launcherSettings.conf!");
            e.printStackTrace();
        }
    }

    private static boolean getPropBoolean(Properties props, String key, boolean defaultProp) {
        String value = props.getProperty(key);
        if (value == null) {
            return defaultProp;
        }
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            return defaultProp;
        }
    }

    private static String getPropString(Properties props, String key, String defaultProp) {
        String value = props.getProperty(key);
        if (value == null) {
            return defaultProp;
        }
        return value;
    }

    public static void saveSettings() {
        try {
            Properties props = new Properties();
            props.setProperty(showBotButtonsKey, Boolean.toString(showBotButtons));
            props.setProperty(autoUpdateKey, Boolean.toString(autoUpdate));
            props.setProperty(firstRunKey, Boolean.toString(false));
            props.setProperty(undecoratedWindowKey, Boolean.toString(undecoratedWindowSave));
            props.setProperty(showPrereleaseKey, Boolean.toString(showPrerelease));
            props.setProperty(preferredClientPreservationKey, preferredClientPreservation);
            props.setProperty(preferredClientCabbageKey, preferredClientCabbage);
            props.setProperty(preferredClient2001scapeKey, preferredClient2001scape);
            props.setProperty(preferredClientOpenpkKey, preferredClientOpenpk);
            props.setProperty(preferredClientUraniumKey, preferredClientUranium);
            props.setProperty(preferredClientColeslawKey, preferredClientColeslaw);
            File cacheDir = new File(Main.configFileLocation);
            if (!cacheDir.exists()) {
                cacheDir.mkdirs();
            }
            FileOutputStream out = new FileOutputStream(Main.configFileLocation + "/launcherSettings.conf");
            props.store(out, "---openrsc launcher config---");
            out.close();
        }
        catch (IOException e) {
            Logger.Error("Could not save launcher settings!");
            e.printStackTrace();
        }
    }

    static {
        undecoratedWindowSave = undecoratedWindow = true;
        logVerbosity = 3;
        preferredClientPreservation = RSCPLUS;
        preferredClientCabbage = OPENRSC;
        preferredClient2001scape = RSCTIMES;
        preferredClientOpenpk = OPENRSC;
        preferredClientUranium = APOSBOT;
        preferredClientColeslaw = IDLERSC;
    }
}

