/*
 * Decompiled with CFR 0.152.
 */
package launcher.Utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.swing.JOptionPane;
import launcher.Gameupdater.Downloader;
import launcher.Main;
import launcher.Utils.Logger;
import launcher.Utils.Utils;

public class ClientLauncher {
    public static void launchClientForServer(String serverName) throws IOException {
        if (Downloader.currently_updating) {
            JOptionPane.showMessageDialog(null, "Updating launcher - please wait until it has finished");
            return;
        }
        switch (serverName) {
            case "cabbage": {
                ClientLauncher.setOpenRSCClientEndpoint("game.revivalrsc.gg", "43594");
                ClientLauncher.launchOpenRSCClient();
                return;
            }
        }
    }

    private static void setOpenRSCClientEndpoint(String ip, String port) {
        OutputStreamWriter outputWriter;
        FileOutputStream fileout;
        try {
            fileout = new FileOutputStream(Main.configFileLocation + File.separator + "ip.txt");
            outputWriter = new OutputStreamWriter(fileout);
            outputWriter.write(ip);
            outputWriter.close();
        }
        catch (Exception e) {
            Logger.Error("Error setting ip.txt: " + e.getMessage());
        }
        try {
            fileout = new FileOutputStream(Main.configFileLocation + File.separator + "port.txt");
            outputWriter = new OutputStreamWriter(fileout);
            outputWriter.write(port);
            outputWriter.close();
        }
        catch (Exception e) {
            Logger.Error("Error setting port.txt: " + e.getMessage());
        }
    }

    private static void launchOpenRSCClient() {
        File f = new File(Main.configFileLocation + File.separator + "client.properties");
        f.delete();
        File configFile = new File(Main.configFileLocation + File.separator + "config.txt");
        configFile.delete();
        File openRscClientJar = new File(Main.configFileLocation + File.separator + "RevivalClient" + ".jar");
        Utils.execCmd(new String[]{"java", "-jar", openRscClientJar.getAbsolutePath()}, openRscClientJar.getParentFile());
    }

    public static void launchRSCPlus() {
        File rscplusJar = new File(Main.configFileLocation + File.separator + "extras" + File.separator + "rscplus" + File.separator + "rscplus.jar");
        Utils.execCmd(new String[]{"java", "-jar", rscplusJar.getAbsolutePath()}, rscplusJar.getParentFile());
    }

    public static void launchRSCTimes() {
        File rsctimesJar = new File(Main.configFileLocation + File.separator + "extras" + File.separator + "rsctimes" + File.separator + "rsctimes.jar");
        Utils.execCmd(new String[]{"java", "-jar", rsctimesJar.getAbsolutePath()}, rsctimesJar.getParentFile());
    }

    public static void launchFleaCircus() {
        File fleaCircusDir = new File(Main.configFileLocation + File.separator + "extras" + File.separator + "fleacircus");
        Utils.execCmd(new String[]{"java", "-cp", fleaCircusDir.getAbsolutePath(), "fleas"}, fleaCircusDir);
    }

    public static void launchAPOS() {
        File aposbotJar = new File(Main.configFileLocation + File.separator + "extras" + File.separator + "apos" + File.separator + "APOS-master" + File.separator + "bot.jar");
        File aposDir = new File(Main.configFileLocation + File.separator + "extras" + File.separator + "apos" + File.separator + "APOS-master");
        try {
            Utils.execCmd(new String[]{"javac", "-cp", "bot.jar;./lib/rsclassic.jar;", "./Scripts/*.java"}, aposDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Utils.execCmd(new String[]{"java", "-jar", aposbotJar.getAbsolutePath()}, aposbotJar.getParentFile());
    }

    public static void launchWinRune(String ip, String port, String version) {
        String rsaKey = "7112866275597968156550007489163685737528267584779959617759901583041864787078477876689003422509099353805015177703670715380710894892460637136582066351659813";
        File winruneJar = new File(Main.configFileLocation + File.separator + "extras" + File.separator + "winrune" + File.separator + "WinRune-master" + File.separator + "rune.jar");
        Utils.execCmd(new String[]{"java", "-jar", winruneJar.getAbsolutePath(), "members=true", "address=" + ip, "port=" + port, "version=" + version, "rsaExponent=65537", "rsaModulus=7112866275597968156550007489163685737528267584779959617759901583041864787078477876689003422509099353805015177703670715380710894892460637136582066351659813"}, winruneJar.getParentFile());
    }

    public static void launchIdleRSC() {
        File idlerscJar = new File(Main.configFileLocation + File.separator + "extras" + File.separator + "idlersc" + File.separator + "IdleRSC" + File.separator + "IdleRSC.jar");
        Utils.execCmd(new String[]{"java", "-jar", idlerscJar.getAbsolutePath()}, idlerscJar.getParentFile());
    }
}

