/*
 * Decompiled with CFR 0.152.
 */
package launcher.Utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import launcher.Utils.Logger;
import launcher.Utils.Utils;

public class CmdRunner
implements Runnable {
    String[] cmdArray;
    File workingDirectory = null;
    boolean needsOutput = false;
    public String output = "";

    public CmdRunner(String[] cmdArray, File workingDirectory, boolean needsOutput) {
        this.cmdArray = cmdArray;
        this.workingDirectory = workingDirectory;
        this.needsOutput = needsOutput;
    }

    @Override
    public void run() {
        try {
            if (!this.workingDirectory.exists()) {
                Logger.Error("Working directory does not exist: [" + this.workingDirectory.getAbsolutePath() + "]. Not launching command.");
                return;
            }
            Process process = Runtime.getRuntime().exec(this.cmdArray, null, this.workingDirectory);
            SequenceInputStream in = new SequenceInputStream(process.getInputStream(), process.getErrorStream());
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((this.output = reader.readLine()) != null) {
                System.out.println(this.output);
                if (!this.needsOutput) continue;
                Utils.lastCommandOutput = this.output;
                Utils.outputCommandRunning = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

