/*
 * Decompiled with CFR 0.152.
 */
package launcher.Utils;

import java.awt.Desktop;
import java.net.URI;
import launcher.Utils.Logger;
import launcher.Utils.Utils;

public class LinkOpener
implements Runnable {
    private String url;

    public LinkOpener(String url) {
        this.url = url;
    }

    @Override
    public void run() {
        boolean hasXdgOpen = Utils.detectBinaryAvailable("xdg-open", "URL opening");
        try {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Logger.Info("Opening \"" + this.url + "\".");
                Desktop.getDesktop().browse(new URI(this.url.replaceAll(" ", "%20")));
            } else if (Utils.isMacOS()) {
                Logger.Info("Opening \"" + this.url + "\".");
                Utils.execCmd(new String[]{"open", this.url}, Utils.getWorkingDirectoryFile(), false);
            } else if (hasXdgOpen) {
                Logger.Info("Using xdg-open to open url \"" + this.url + "\".");
                Utils.execCmd(new String[]{"xdg-open", this.url}, Utils.getWorkingDirectoryFile(), false);
            } else {
                Logger.Warn("Please install xdg-open to reliably open URLs on your system.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

