/*
 * Decompiled with CFR 0.152.
 */
package launcher.Utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import launcher.Settings;

public class Logger {
    private static PrintWriter m_logWriter;
    private static int levelFixedWidth;
    private static String m_uncoloredMessage;

    public static void start() {
        File file = new File("log.txt");
        try {
            m_logWriter = new PrintWriter(new FileOutputStream(file));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void stop() {
        try {
            m_logWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void Log(Type type, String message) {
        try {
            if (type.id > Settings.logVerbosity || message == null) {
                return;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
            String msg = message;
            String extra = "";
            if (type.showLevel) {
                String levelText = type.name.toUpperCase();
                while (levelText.length() < levelFixedWidth) {
                    levelText = " " + levelText;
                }
                extra = extra + "[" + levelText + "]";
            }
            if (type.showTimestamp) {
                extra = extra + "[" + dateFormat.format(new Date()) + "]";
            }
            if (extra.length() > 0) {
                msg = extra + " " + msg;
            }
            if (type != Type.ERROR) {
                System.out.println(msg);
            } else {
                System.err.println(msg);
            }
            try {
                if (m_uncoloredMessage.length() > 0) {
                    msg = m_uncoloredMessage;
                    m_uncoloredMessage = "";
                }
                m_logWriter.write(msg + "\r\n");
                m_logWriter.flush();
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            try {
                System.out.println("Logger died, heres the report:");
                e.printStackTrace();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void Error(String message) {
        Logger.Log(Type.ERROR, message);
    }

    public static void Warn(String message) {
        Logger.Log(Type.WARN, message);
    }

    public static void Info(String message) {
        Logger.Log(Type.INFO, message);
    }

    public static void Debug(String message) {
        Logger.Log(Type.DEBUG, message);
    }

    static {
        levelFixedWidth = 0;
        m_uncoloredMessage = "";
    }

    public static enum Type {
        ERROR(0, "error", true, true),
        WARN(1, "warn", true, true),
        INFO(3, "info", true, true),
        DEBUG(4, "debug", true, true);

        public int id;
        public String name;
        public boolean showLevel;
        public boolean showTimestamp;

        private Type(int id, String name, boolean showLevel, boolean showTimestamp) {
            this.id = id;
            this.name = name;
            this.showLevel = showLevel;
            this.showTimestamp = showTimestamp;
            levelFixedWidth = levelFixedWidth < name.length() ? name.length() : levelFixedWidth;
        }
    }
}

