/*
 * Decompiled with CFR 0.152.
 */
package launcher.Utils;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.ImageIcon;
import launcher.Main;
import launcher.Utils.CmdRunner;
import launcher.Utils.Defaults;
import launcher.Utils.LinkOpener;
import launcher.Utils.Logger;

public class Utils {
    private static DateFormat df;
    private static long timeCorrection;
    private static long lastTimeUpdate;
    public static volatile boolean outputCommandRunning;
    public static String lastCommandOutput;

    public static boolean isValidPath(String path) {
        File checkFile = new File(path);
        try {
            checkFile.getCanonicalPath();
            return true;
        }
        catch (Exception error) {
            return false;
        }
    }

    public static String getCanonicalPath(String path) {
        File checkFile = new File(path);
        try {
            return checkFile.getCanonicalPath();
        }
        catch (Exception error) {
            return Main.configFileLocation;
        }
    }

    public static File getWorkingDirectoryFile() {
        return new File(System.getProperty("user.dir"));
    }

    public static ImageIcon getImage(String name) {
        return new ImageIcon(Utils.class.getResource("/data/images/" + name));
    }

    public static void openWebpage(String url) {
        Thread t = new Thread(new LinkOpener(url));
        t.start();
    }

    public static Font getFont(String fontName, int type, float size) {
        try {
            Font font = Font.createFont(0, Utils.class.getResource("/data/fonts/" + fontName).openStream());
            GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
            genv.registerFont(font);
            font = font.deriveFont(type, size);
            return font;
        }
        catch (Exception error) {
            error.printStackTrace();
            return null;
        }
    }

    public static String getServerTime() {
        if (df == null) {
            df = new SimpleDateFormat("h:mm:ss a");
            df.setTimeZone(TimeZone.getTimeZone("America/New_York"));
        }
        return df.format(new Date());
    }

    public static void execCmd(String[] cmdArray, File workingDirectory) {
        Utils.execCmd(cmdArray, workingDirectory, false);
    }

    public static void execCmd(String[] cmdArray, File workingDirectory, boolean needsOutput) {
        if (needsOutput) {
            outputCommandRunning = true;
            lastCommandOutput = null;
        }
        Thread t = new Thread(new CmdRunner(cmdArray, workingDirectory, needsOutput));
        t.start();
    }

    public static boolean isMacOS() {
        String os = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        return os.contains("mac") || os.contains("darwin");
    }

    public static boolean detectBinaryAvailable(String binaryName, String reason) {
        if (System.getProperty("os.name").contains("Windows")) {
            return false;
        }
        try {
            Utils.execCmd(new String[]{"whereis", "-b", binaryName}, Utils.getWorkingDirectoryFile(), true);
            while (outputCommandRunning) {
            }
            String whereis = lastCommandOutput.replace("\n", "").replace(binaryName + ": ", "");
            if (whereis.length() < ("/" + binaryName).length()) {
                Logger.Error(String.format("@|red !!! Please install %s for %s to work on Linux (or other systems with compatible binary) !!!|@", binaryName, reason));
                return false;
            }
            Logger.Info(binaryName + ": " + whereis);
            return true;
        }
        catch (Exception e) {
            Logger.Error("Error while detecting " + binaryName + " binary: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static boolean notMacWindows() {
        if (System.getProperty("os.name").contains("Windows")) {
            return false;
        }
        return !Utils.isMacOS();
    }

    public static String stripHtml(String text) {
        return text.replaceAll("\\<.*?\\>", "");
    }

    public static String generateUserAgent() {
        StringBuilder sb = new StringBuilder("Mozilla/5.0 (");
        sb.append(System.getProperty("os.name"));
        sb.append("; ");
        sb.append(System.getProperty("os.arch"));
        sb.append("; ");
        sb.append(System.getProperty("os.version"));
        sb.append(") OpenRSCLauncher/");
        sb.append(String.format("%8.6f", Defaults._CURRENT_VERSION));
        return sb.toString();
    }

    static {
        outputCommandRunning = false;
        lastCommandOutput = null;
    }
}

