/*
 * Decompiled with CFR 0.152.
 */
package launcher.Utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Arrays;
import launcher.Utils.Utils;

public class WorldPopulations
implements Runnable {
    static final int WORLDS_SUPPORTED = 6;
    public static final int PRESERVATION = 0;
    public static final int CABBAGE = 1;
    public static final int URANIUM = 2;
    public static final int COLESLAW = 3;
    public static final int TWOTHOUSANDONESCAPE = 4;
    public static final int OPENPK = 5;
    public static final int KALE = 6;
    private static long lastPopCheck = 0L;
    public static String[] worldOnlineTexts = new String[6];

    public static void updateWorldPopulations() {
        Thread t = new Thread(new WorldPopulations());
        t.start();
    }

    @Override
    public void run() {
        BufferedReader br;
        if (System.currentTimeMillis() < lastPopCheck + 1000L) {
            return;
        }
        String[] splitWorldTotals = null;
        lastPopCheck = System.currentTimeMillis();
        InputStream is = null;
        try {
            URL url = new URL("https://rsc.vet/onlinelookup");
            URLConnection con = url.openConnection();
            con.setConnectTimeout(3000);
            con.setReadTimeout(3000);
            con.addRequestProperty("User-Agent", Utils.generateUserAgent());
            is = con.getInputStream();
            br = new BufferedReader(new InputStreamReader(is));
        }
        catch (UnknownHostException uhe) {
            if (null == worldOnlineTexts[0] || null == worldOnlineTexts[2]) {
                Arrays.fill(worldOnlineTexts, "You're offline");
            }
            return;
        }
        catch (SocketTimeoutException ste) {
            if (null == worldOnlineTexts[0] || null == worldOnlineTexts[2]) {
                Arrays.fill(worldOnlineTexts, "Socket timeout");
            }
            return;
        }
        catch (IOException ioe) {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (ioe.toString().contains("Server returned HTTP response code: 521")) {
                Arrays.fill(worldOnlineTexts, "Webserver offline");
            } else {
                Arrays.fill(worldOnlineTexts, "Webserver offline?");
            }
            return;
        }
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                splitWorldTotals = line.split(",");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        try {
            br.close();
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (null == splitWorldTotals) {
            for (int i = 0; i < 6; ++i) {
                WorldPopulations.worldOnlineTexts[i] = "";
            }
        } else {
            for (int i = 0; i < 6 && i < splitWorldTotals.length; ++i) {
                boolean isNumber;
                try {
                    Integer.parseInt(splitWorldTotals[i]);
                    isNumber = true;
                }
                catch (NumberFormatException nfe) {
                    isNumber = false;
                }
                if (isNumber) {
                    int n = i;
                    splitWorldTotals[n] = splitWorldTotals[n] + " online";
                }
                WorldPopulations.worldOnlineTexts[i] = splitWorldTotals[i];
            }
        }
    }
}

