/*
 * Decompiled with CFR 0.152.
 */
package launcher.elements;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import launcher.Main;
import launcher.elements.RadioButton;
import launcher.listeners.CheckComboListener;

public class CheckCombo
extends JComboBox
implements ListCellRenderer {
    public RadioButton checkBox;
    public JComboBox combo;
    boolean keepMenuOpen;

    @Override
    public void setPopupVisible(boolean v) {
        super.setPopupVisible(v);
    }

    public CheckCombo() {
        this.init();
    }

    public void setContents(store[] stores) {
        this.combo.removeAllItems();
        this.combo.repaint();
    }

    private void init() {
        this.checkBox = new RadioButton(new Rectangle(0, 0, 20, 15));
        this.checkBox.setContentAreaFilled(true);
        store[] stores = new store[]{new store("none", true)};
        this.combo = new JComboBox();
        this.combo.setRenderer(this);
        this.combo.setBackground(Color.black);
        this.combo.setForeground(Color.white);
        this.combo.addActionListener(new CheckComboListener());
        this.combo.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                CheckCombo.this.keepMenuOpen = true;
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CheckCombo.this.combo.setPopupVisible(CheckCombo.this.keepMenuOpen);
                    }
                });
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                CheckCombo.this.keepMenuOpen = false;
            }
        });
        this.combo.setVisible(true);
        this.setContents(stores);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value != null) {
            store store2 = (store)value;
            this.checkBox.setText(store2.text);
            this.checkBox.setSelected(store2.state);
        } else {
            this.checkBox.setSelected(false);
        }
        this.combo.setBackground(Color.black);
        this.combo.setForeground(Color.white);
        return this.checkBox;
    }

    public void loadSpritePacks() {
        store[] stores = null;
        try {
            File configFile = new File(Main.configFileLocation, "config.txt");
            configFile.createNewFile();
            File spDir = new File(Main.SPRITEPACK_DIR);
            File[] spritePacks = spDir.listFiles(File::isFile);
            if (spritePacks.length > 0) {
                String line;
                ArrayList<String> packsAvailable = new ArrayList<String>();
                HashMap<String, Boolean> packsSettings = new HashMap<String, Boolean>();
                for (File spritePack : spritePacks) {
                    int index = spritePack.getName().lastIndexOf(46);
                    String name = spritePack.getName().substring(0, index);
                    packsAvailable.add(name);
                }
                BufferedReader br = new BufferedReader(new FileReader(configFile));
                while ((line = br.readLine()) != null) {
                    String[] packageName = line.split(":");
                    if (!packsAvailable.contains(packageName[0])) continue;
                    packsSettings.put(packageName[0], Integer.parseInt(packageName[1]) == 1);
                }
                br.close();
                Iterator look = packsAvailable.iterator();
                FileWriter write = new FileWriter(configFile, true);
                PrintWriter writer = new PrintWriter(write);
                while (look.hasNext()) {
                    String nextPack = (String)look.next();
                    if (packsSettings.get(nextPack) != null) continue;
                    writer.println(nextPack + ":0");
                    packsSettings.put(nextPack, false);
                }
                writer.close();
                write.close();
                if (packsSettings.size() > 0) {
                    stores = new store[packsSettings.size()];
                    Iterator it = packsSettings.entrySet().iterator();
                    int j = 0;
                    while (it.hasNext()) {
                        Map.Entry pair = it.next();
                        stores[j++] = new store((String)pair.getKey(), (Boolean)pair.getValue());
                    }
                }
            }
        }
        catch (IOException a) {
            a.printStackTrace();
        }
        if (stores != null) {
            this.setContents(stores);
        }
        this.combo.repaint();
    }

    public class store {
        public String text;
        public Boolean state;

        public store(String id, Boolean state) {
            this.text = id;
            this.state = state;
        }
    }
}

