/*
 * Decompiled with CFR 0.152.
 */
package launcher.elements;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import launcher.Utils.Utils;
import launcher.listeners.ButtonListener;

public class LaunchButton
extends JButton
implements MouseListener {
    private static final long serialVersionUID = -3245141651685683983L;

    public LaunchButton(String game) {
        this.setIcon(Utils.getImage(game + "_logo.png"));
        try {
            this.setRolloverIcon(Utils.getImage(game + "_logo_hover.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setHorizontalTextPosition(0);
        this.setFont(Utils.getFont("Helvetica.otf", 1, 18.0f));
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setForeground(Color.WHITE);
        this.setFocusable(false);
        this.setActionCommand(game);
        this.addActionListener(new ButtonListener());
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.setLocation(this.getX(), this.getY() + 1);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setLocation(this.getX(), this.getY() - 1);
    }
}

