/*
 * Decompiled with CFR 0.152.
 */
package launcher.elements;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import launcher.Utils.Utils;
import launcher.listeners.ButtonListener;

public class LinkButton
extends JButton
implements MouseListener {
    private static final long serialVersionUID = 3503904237989217533L;

    public LinkButton(String imageFileName, Rectangle bounds) {
        this.setIcon(Utils.getImage(imageFileName + ".png"));
        try {
            this.setRolloverIcon(Utils.getImage(imageFileName + "_hover.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(1);
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setForeground(Color.WHITE);
        this.setBounds(bounds);
        this.setFocusable(false);
        this.setActionCommand(imageFileName);
        this.addActionListener(new ButtonListener());
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.setLocation(this.getX(), this.getY() + 1);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setLocation(this.getX(), this.getY() - 1);
    }
}

