/*
 * Decompiled with CFR 0.152.
 */
package launcher.popup;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import launcher.Fancy.MainWindow;
import launcher.Settings;
import launcher.Utils.Logger;
import launcher.Utils.Utils;
import launcher.elements.CheckboxButton;
import launcher.elements.ClientSettingsCard;
import launcher.elements.ControlButton;
import launcher.elements.LaunchButton;
import launcher.elements.LinkButton;
import launcher.popup.ClientDescriptions;
import launcher.popup.SavedIndicatorThread;

public class PopupFrame
extends JLabel {
    public static PopupFrame instance;
    private static final long serialVersionUID = 8654472888657426168L;
    private JLabel POPUP_BACKGROUND;
    public static final int LAUNCHER_SETTINGS = 0;
    public static final int CLIENT_SETTINGS = 1;
    private final int CLIENT_LOGO_LARGE_X = 10;
    private final int CLIENT_LOGO_LARGE_Y = 120;
    private final int EXPLANATION_X = 145;
    private final int EXPLANATION_Y = 120;
    private final int CLIENT_CHOOSER_X = 10;
    private final int CLIENT_CHOOSER_Y = 245;
    private final int SERVER_X = 150;
    private final int SERVER_Y = 10;
    private final String preservationName = "RSC Preservation";
    private final String cabbageName = "RSC Cabbage";
    private final String O1scapeName = "2001scape";
    private final String kaleName = "RSC Kale";
    private final String openPKName = "Open PK (pre-release)";
    private final String uraniumName = "RSC Uranium";
    private final String coleslawName = "RSC Coleslaw";
    private final int PRESERVATION_IDX = 0;
    private final int CABBAGE_IDX = 1;
    private final int O1SCAPE_IDX = 2;
    private final int OPENPK_IDX = 3;
    private final int URANIUM_IDX = 4;
    private final int COLESLAW_IDX = 5;
    private final String[] serverChooserNames = new String[]{"RSC Preservation", "RSC Cabbage", "2001scape", "Open PK (pre-release)", "RSC Uranium", "RSC Coleslaw"};
    private final JComboBox serverChooser = new JComboBox<String>(this.serverChooserNames);
    private int serverChooserLastIdx = 0;
    private JButton[] serverNameRSC;
    private JButton[] serverName;
    private JLabel horizontalRule;
    HashMap<String, String> clientNameTranslator = new HashMap();
    public static ClientSettingsCard preservationSettingsCard;
    public static ClientSettingsCard cabbageSettingsCard;
    public static ClientSettingsCard O1scapeSettingsCard;
    public static ClientSettingsCard openpkSettingsCard;
    public static ClientSettingsCard uraniumSettingsCard;
    public static ClientSettingsCard coleslawSettingsCard;

    public PopupFrame(int popupId) {
        this.build(popupId);
    }

    public static PopupFrame get() {
        return instance;
    }

    private void build(int popupId) {
        this.defineClientSettingLookup();
        ClientDescriptions.init();
        this.setBounds(new Rectangle(58, 51, 692, 405));
        this.setLayout(null);
        this.POPUP_BACKGROUND = new JLabel();
        this.POPUP_BACKGROUND.setBounds(0, 0, 689, 405);
        this.POPUP_BACKGROUND.setForeground(Color.WHITE);
        this.POPUP_BACKGROUND.setHorizontalAlignment(0);
        this.POPUP_BACKGROUND.setFont(Utils.getFont("Helvetica.otf", 0, 12.0f));
        this.add(this.POPUP_BACKGROUND);
        int control_button_width = 10;
        int control_button_height = 11;
        ControlButton popup_minimize = new ControlButton(1, 637, 9, control_button_width, control_button_height);
        ControlButton popup_close = new ControlButton(2, 657, 9, control_button_width, control_button_height);
        if (Settings.undecoratedWindow) {
            this.POPUP_BACKGROUND.add(popup_minimize);
            this.POPUP_BACKGROUND.add(popup_close);
        }
        LaunchButton fleaCircusEgg = new LaunchButton("fleacircus");
        fleaCircusEgg.setBounds(0, 2, 20, 20);
        this.POPUP_BACKGROUND.add(fleaCircusEgg);
        int x = 28;
        int y = 366;
        LinkButton question_mark = new LinkButton("question_mark", new Rectangle(x, y, 22, 35));
        LinkButton about_our_servers = new LinkButton("about_our_servers_button", new Rectangle(x + 22 + 4, y, 160, 35));
        LinkButton floppy_disk = new LinkButton("floppy_disk", new Rectangle(x += 209, y, 35, 35));
        LinkButton apply_and_save_button = new LinkButton("apply_and_save_button", new Rectangle(x + 35 + 5, y, 160, 35));
        LinkButton gear = new LinkButton("exit_gear", new Rectangle(x += 218, y, 35, 35));
        LinkButton close = new LinkButton("exit_settings_button", new Rectangle(x + 35 + 4, y, 160, 35));
        this.POPUP_BACKGROUND.add(floppy_disk);
        this.POPUP_BACKGROUND.add(apply_and_save_button);
        this.POPUP_BACKGROUND.add(question_mark);
        this.POPUP_BACKGROUND.add(about_our_servers);
        this.POPUP_BACKGROUND.add(gear);
        this.POPUP_BACKGROUND.add(close);
        switch (popupId) {
            case 0: {
                this.buildLauncherSettingsPage();
                break;
            }
            case 1: {
                this.buildClientSettingsPage();
            }
        }
        instance = this;
        MainWindow.get()._BACKGROUND.revalidate();
        MainWindow.get().pack();
        MainWindow.get()._BACKGROUND.repaint();
    }

    private void buildLauncherSettingsPage() {
        int x = 65;
        int y = 35;
        JLabel header = new JLabel("Advanced Settings");
        header.setFont(MainWindow.helvetica24b);
        header.setBorder(new EmptyBorder(0, 0, 0, 0));
        int headerHeight = header.getFontMetrics(MainWindow.helvetica24b).getHeight();
        header.setBounds(x, y, header.getPreferredSize().width, headerHeight);
        header.setForeground(MainWindow.yellow);
        this.POPUP_BACKGROUND.add(header);
        int labelWidth = PopupFrame.makeCheckboxLabel("<html>Custom Window Chrome (aka Undecorated Window) <font color=red>(requires restart)</font></html>", x + 22, (y += headerHeight + 10) + 4, this.POPUP_BACKGROUND);
        CheckboxButton undecorated = new CheckboxButton("undecorated_checkbox", new Rectangle(x, y, 25 + labelWidth, 25));
        undecorated.setSelected(Settings.undecoratedWindowSave);
        this.POPUP_BACKGROUND.add(undecorated);
        labelWidth = PopupFrame.makeCheckboxLabel("<html>Automatically update launcher on start <font color=red>(requires restart)</font></html>", x + 22, (y += 40) + 4, this.POPUP_BACKGROUND);
        CheckboxButton autoupdate = new CheckboxButton("autoupdate_checkbox", new Rectangle(x, y, 25 + labelWidth, 25));
        autoupdate.setSelected(Settings.autoUpdate);
        this.POPUP_BACKGROUND.add(autoupdate);
        labelWidth = PopupFrame.makeCheckboxLabel("<html>Show pre-release servers on main page</html>", x + 22, (y += 40) + 4, this.POPUP_BACKGROUND);
        CheckboxButton showPrerelease = new CheckboxButton("show_prerelease_checkbox", new Rectangle(x, y, 25 + labelWidth + 21, 25));
        showPrerelease.setSelected(Settings.showPrerelease);
        this.POPUP_BACKGROUND.add(showPrerelease);
        JLabel dukeConstruction = new JLabel(Utils.getImage("dukeconstruction.gif"));
        dukeConstruction.setBounds(x + 25 + labelWidth, y, 21, 24);
        dukeConstruction.setFocusable(false);
        dukeConstruction.setBorder(BorderFactory.createEmptyBorder());
        this.POPUP_BACKGROUND.add(dukeConstruction);
        y += 40;
    }

    private void buildClientSettingsPage() {
        int SERVER_CHOOSER_WIDTH = 200;
        this.serverChooser.setMinimumSize(new Dimension(200, 28));
        this.serverChooser.setMaximumSize(new Dimension(200, 28));
        this.serverChooser.setPreferredSize(new Dimension(200, 28));
        this.serverChooser.setAlignmentY(0.75f);
        this.serverChooser.setBounds(260, 75, 200, 28);
        this.POPUP_BACKGROUND.add(this.serverChooser);
        this.horizontalRule = new JLabel(Utils.getImage("horizontal.rule.png"));
        this.horizontalRule.setBounds(260, 60, 208, 3);
        this.POPUP_BACKGROUND.add(this.horizontalRule);
        this.serverNameRSC = new JButton[this.serverChooserNames.length];
        this.serverName = new JButton[this.serverChooserNames.length];
        for (int i = 0; i < this.serverName.length; ++i) {
            Rectangle origNameBounds = this.serverName[i].getBounds();
            Rectangle origRSCBounds = this.serverNameRSC[i].getBounds();
            if (i == 2) {
                origNameBounds.x += 260 - origRSCBounds.x;
                origRSCBounds.x = 260;
                origNameBounds.y += 30 - origRSCBounds.y;
                origRSCBounds.y = 30;
            } else if (i == 3) {
                origRSCBounds.x += 260 - origNameBounds.x;
                origNameBounds.x = 260;
                origRSCBounds.y += 30 - origNameBounds.y;
                origNameBounds.y = 30;
            } else {
                origNameBounds.x = origRSCBounds.x = 260;
                origRSCBounds.y += 30 - origNameBounds.y;
                origNameBounds.y = 30;
            }
            this.serverNameRSC[i].setBounds(origRSCBounds);
            this.serverName[i].setBounds(origNameBounds);
        }
        if (Settings.showBotButtons) {
            this.POPUP_BACKGROUND.add(this.serverNameRSC[4]);
            this.POPUP_BACKGROUND.add(this.serverName[4]);
            this.POPUP_BACKGROUND.add(PopupFrame.uraniumSettingsCard.logo);
            this.POPUP_BACKGROUND.setComponentZOrder(PopupFrame.uraniumSettingsCard.logo, 5);
            this.POPUP_BACKGROUND.add(PopupFrame.uraniumSettingsCard.clientLogoSmall);
            this.POPUP_BACKGROUND.setComponentZOrder(PopupFrame.uraniumSettingsCard.clientLogoSmall, 3);
            this.serverChooser.setSelectedIndex(4);
            this.serverChooserLastIdx = 4;
        } else {
            this.POPUP_BACKGROUND.add(this.serverNameRSC[0]);
            this.POPUP_BACKGROUND.add(this.serverName[0]);
            this.POPUP_BACKGROUND.add(PopupFrame.preservationSettingsCard.logo);
            this.POPUP_BACKGROUND.setComponentZOrder(PopupFrame.preservationSettingsCard.logo, 5);
            this.POPUP_BACKGROUND.add(PopupFrame.preservationSettingsCard.clientLogoSmall);
            this.POPUP_BACKGROUND.setComponentZOrder(PopupFrame.preservationSettingsCard.clientLogoSmall, 3);
            this.serverChooser.setSelectedIndex(0);
            this.serverChooserLastIdx = 0;
        }
        this.serverChooser.addActionListener(arg0 -> this.serverChooserActionListener());
    }

    private JLabel updateSmallClientIcon(ActionEvent arg0, LaunchButton launchButton, String[] jComboBoxItems) {
        JComboBox clientChooser = (JComboBox)arg0.getSource();
        return MainWindow.get().defineClientLogo(launchButton, jComboBoxItems[clientChooser.getSelectedIndex()]);
    }

    private LinkButton updateLargeClientIcon(ActionEvent arg0, LaunchButton launchButton, String[] jComboBoxItems) {
        JComboBox clientChooser = (JComboBox)arg0.getSource();
        return this.defineClientLogoButton(launchButton, this.clientNameTranslator.get(jComboBoxItems[clientChooser.getSelectedIndex()]));
    }

    private void defineClientSettingLookup() {
        this.clientNameTranslator.put("rscplus", "RSC+");
        this.clientNameTranslator.put("winrune", "WinRune");
        this.clientNameTranslator.put("openrsc", "Open RSC Client");
        this.clientNameTranslator.put("mudclient38", "Mudclient 38");
        this.clientNameTranslator.put("idlersc", "IdleRSC");
        this.clientNameTranslator.put("aposbot", "APOSbot");
        this.clientNameTranslator.put("rsctimes", "RSCx");
        this.clientNameTranslator.put("webclient", "Web Client");
        this.clientNameTranslator.put("RSC+", "rscplus");
        this.clientNameTranslator.put("WinRune", "winrune");
        this.clientNameTranslator.put("Open RSC Client", "openrsc");
        this.clientNameTranslator.put("Mudclient 38", "mudclient38");
        this.clientNameTranslator.put("IdleRSC", "idlersc");
        this.clientNameTranslator.put("APOSbot", "aposbot");
        this.clientNameTranslator.put("RSCx", "rsctimes");
        this.clientNameTranslator.put("Web Client", "webclient");
    }

    private void setIndexFromSave(JComboBox clientChooser, String preferredClient) {
        String searchMe = this.clientNameTranslator.get(preferredClient);
        for (int i = 0; i < clientChooser.getItemCount(); ++i) {
            if (!clientChooser.getItemAt(i).equals(searchMe)) continue;
            clientChooser.setSelectedIndex(i);
            return;
        }
    }

    public void hideFrame() {
        this.setVisible(false);
        MainWindow.get().addButtons();
        MainWindow.get().addServerButtons();
    }

    public void showFrame() {
        this.setVisible(true);
        MainWindow.get()._BACKGROUND.add(this);
        MainWindow.get().pack();
        MainWindow.get()._BACKGROUND.repaint();
    }

    @Override
    public void setVisible(boolean visible) {
        this.POPUP_BACKGROUND.setVisible(visible);
        this.repaint();
        MainWindow.get().pack();
        MainWindow.get()._BACKGROUND.repaint();
    }

    public void clientChooserAction(ActionEvent actionEvent, ClientSettingsCard serverCard) {
        this.POPUP_BACKGROUND.remove(serverCard.clientLogoSmall);
        serverCard.clientLogoSmall = this.updateSmallClientIcon(actionEvent, serverCard.logo, serverCard.clientNames);
        this.POPUP_BACKGROUND.add(serverCard.clientLogoSmall);
        this.POPUP_BACKGROUND.setComponentZOrder(serverCard.clientLogoSmall, 3);
        this.POPUP_BACKGROUND.remove(serverCard.explanationTexts[serverCard.activeExplanation]);
        serverCard.activeExplanation = serverCard.clientChooser.getSelectedIndex();
        Dimension newSize = serverCard.explanationTexts[serverCard.activeExplanation].getPreferredSize();
        serverCard.explanationTexts[serverCard.clientChooser.getSelectedIndex()].setBounds(145, 120, (int)newSize.getWidth(), (int)newSize.getHeight());
        this.POPUP_BACKGROUND.add(serverCard.explanationTexts[serverCard.activeExplanation]);
        this.POPUP_BACKGROUND.remove(serverCard.clientLogoLarge);
        serverCard.clientLogoLarge = this.updateLargeClientIcon(actionEvent, serverCard.logo, serverCard.clientNames);
        this.POPUP_BACKGROUND.add(serverCard.clientLogoLarge);
        this.POPUP_BACKGROUND.repaint();
    }

    public void setupCard(ClientSettingsCard serverCard, String[] clientNames, String preferredClient, LaunchButton logo, boolean active, HashMap<String, JLabel> clientDescriptions, boolean isPrerelease) {
        int CLIENT_CHOOSER_WIDTH = 120;
        serverCard.clientNames = clientNames;
        serverCard.clientChooser = new JComboBox<String>(serverCard.clientNames);
        serverCard.clientChooser.setMinimumSize(new Dimension(120, 28));
        serverCard.clientChooser.setMaximumSize(new Dimension(120, 28));
        serverCard.clientChooser.setPreferredSize(new Dimension(120, 28));
        serverCard.clientChooser.setAlignmentY(0.75f);
        this.setIndexFromSave(serverCard.clientChooser, preferredClient);
        serverCard.logo = logo;
        serverCard.logo.setBounds(150, 10, 100, 100);
        serverCard.clientLogoSmall = MainWindow.get().defineClientLogo(serverCard.logo, serverCard.clientChooser.getSelectedItem().toString());
        serverCard.clientLogoLarge = this.defineClientLogoButton(serverCard.logo, serverCard.clientChooser.getSelectedItem().toString());
        serverCard.clientChooser.setBounds(10, 245, 120, 28);
        serverCard.explanationTexts = new JLabel[serverCard.clientNames.length];
        for (int i = 0; i < serverCard.clientNames.length; ++i) {
            serverCard.explanationTexts[i] = clientDescriptions.getOrDefault(serverCard.clientNames[i], ClientDescriptions.unknownClient);
        }
        serverCard.activeExplanation = serverCard.clientChooser.getSelectedIndex();
        Dimension size = serverCard.explanationTexts[serverCard.activeExplanation].getPreferredSize();
        serverCard.explanationTexts[serverCard.activeExplanation].setBounds(145, 120, (int)size.getWidth(), (int)size.getHeight());
        serverCard.clientChooser.addActionListener(arg0 -> this.clientChooserAction(arg0, serverCard));
        if (active) {
            this.POPUP_BACKGROUND.add(serverCard.clientLogoLarge);
            this.POPUP_BACKGROUND.add(serverCard.clientChooser);
            this.POPUP_BACKGROUND.add(serverCard.explanationTexts[serverCard.activeExplanation]);
        }
        serverCard.isPrerelease = isPrerelease;
        if (isPrerelease) {
            serverCard.constructionLogo = new JLabel(Utils.getImage("undercon.gif"));
            serverCard.constructionLogo.setBounds(150, 72, 38, 38);
            serverCard.constructionLogo.setFocusable(false);
            serverCard.constructionLogo.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    private void serverChooserActionListener() {
        this.POPUP_BACKGROUND.remove(this.serverName[this.serverChooserLastIdx]);
        this.POPUP_BACKGROUND.remove(this.serverNameRSC[this.serverChooserLastIdx]);
        switch (this.serverChooserLastIdx) {
            case 0: {
                this.POPUP_BACKGROUND = preservationSettingsCard.removeAll(this.POPUP_BACKGROUND);
                break;
            }
            case 1: {
                this.POPUP_BACKGROUND = cabbageSettingsCard.removeAll(this.POPUP_BACKGROUND);
                break;
            }
            case 2: {
                this.POPUP_BACKGROUND = O1scapeSettingsCard.removeAll(this.POPUP_BACKGROUND);
                break;
            }
            case 3: {
                this.POPUP_BACKGROUND = openpkSettingsCard.removeAll(this.POPUP_BACKGROUND);
                break;
            }
            case 4: {
                this.POPUP_BACKGROUND = uraniumSettingsCard.removeAll(this.POPUP_BACKGROUND);
                break;
            }
            case 5: {
                this.POPUP_BACKGROUND = coleslawSettingsCard.removeAll(this.POPUP_BACKGROUND);
                break;
            }
            default: {
                Logger.Error("Unimplemented server in serverChooserListener remove section");
            }
        }
        this.POPUP_BACKGROUND.add(this.serverName[this.serverChooser.getSelectedIndex()]);
        this.POPUP_BACKGROUND.add(this.serverNameRSC[this.serverChooser.getSelectedIndex()]);
        switch (this.serverChooser.getSelectedIndex()) {
            case 0: {
                this.POPUP_BACKGROUND = preservationSettingsCard.addAll(this.POPUP_BACKGROUND);
                break;
            }
            case 1: {
                this.POPUP_BACKGROUND = cabbageSettingsCard.addAll(this.POPUP_BACKGROUND);
                break;
            }
            case 2: {
                this.POPUP_BACKGROUND = O1scapeSettingsCard.addAll(this.POPUP_BACKGROUND);
                break;
            }
            case 3: {
                this.POPUP_BACKGROUND = openpkSettingsCard.addAll(this.POPUP_BACKGROUND);
                break;
            }
            case 4: {
                this.POPUP_BACKGROUND = uraniumSettingsCard.addAll(this.POPUP_BACKGROUND);
                break;
            }
            case 5: {
                this.POPUP_BACKGROUND = coleslawSettingsCard.addAll(this.POPUP_BACKGROUND);
                break;
            }
            default: {
                Logger.Error("Unimplemented server in serverChooserListener add section");
            }
        }
        this.serverChooserLastIdx = this.serverChooser.getSelectedIndex();
        this.POPUP_BACKGROUND.revalidate();
        this.POPUP_BACKGROUND.repaint();
    }

    public void saveClientSelectionsToSettings() {
        Settings.preferredClientPreservation = this.clientNameTranslator.getOrDefault(PopupFrame.preservationSettingsCard.clientNames[PopupFrame.preservationSettingsCard.clientChooser.getSelectedIndex()], Settings.preferredClientPreservation);
        Settings.preferredClientCabbage = this.clientNameTranslator.getOrDefault(PopupFrame.cabbageSettingsCard.clientNames[PopupFrame.cabbageSettingsCard.clientChooser.getSelectedIndex()], Settings.preferredClientCabbage);
        Settings.preferredClient2001scape = this.clientNameTranslator.getOrDefault(PopupFrame.O1scapeSettingsCard.clientNames[PopupFrame.O1scapeSettingsCard.clientChooser.getSelectedIndex()], Settings.preferredClient2001scape);
        Settings.preferredClientOpenpk = this.clientNameTranslator.getOrDefault(PopupFrame.openpkSettingsCard.clientNames[PopupFrame.openpkSettingsCard.clientChooser.getSelectedIndex()], Settings.preferredClientOpenpk);
        Settings.preferredClientUranium = this.clientNameTranslator.getOrDefault(PopupFrame.uraniumSettingsCard.clientNames[PopupFrame.uraniumSettingsCard.clientChooser.getSelectedIndex()], Settings.preferredClientUranium);
        Settings.preferredClientColeslaw = this.clientNameTranslator.getOrDefault(PopupFrame.coleslawSettingsCard.clientNames[PopupFrame.coleslawSettingsCard.clientChooser.getSelectedIndex()], Settings.preferredClientColeslaw);
        Settings.saveSettings();
        this.spawnSavedText(100);
    }

    private void spawnSavedText(int animationFrame) {
        Thread t = new Thread(new SavedIndicatorThread(animationFrame, this.POPUP_BACKGROUND));
        t.start();
    }

    public LinkButton defineClientLogoButton(LaunchButton logo, String preferredClient) {
        String server = logo.getActionCommand();
        if (null == preferredClient) {
            switch (server) {
                case "preservation": {
                    preferredClient = Settings.preferredClientPreservation;
                    break;
                }
                case "cabbage": {
                    preferredClient = Settings.preferredClientCabbage;
                    break;
                }
                case "2001scape": {
                    preferredClient = Settings.preferredClient2001scape;
                    break;
                }
                case "kale": {
                    preferredClient = Settings.preferredClientKale;
                    break;
                }
                case "openpk": {
                    preferredClient = Settings.preferredClientOpenpk;
                    break;
                }
                case "uranium": {
                    preferredClient = Settings.preferredClientUranium;
                    break;
                }
                case "coleslaw": {
                    preferredClient = Settings.preferredClientColeslaw;
                }
            }
        }
        if (null == preferredClient) {
            Logger.Error("No client defined for server " + server);
            preferredClient = "notdefined";
        }
        String icon = null;
        switch (preferredClient) {
            case "openrsc": 
            case "Open RSC Client": {
                icon = "openrsc-client-large";
                break;
            }
            case "rscplus": 
            case "RSC+": {
                icon = "rscplus-large";
                break;
            }
            case "aposbot": 
            case "APOSbot": {
                icon = "aposbot-large";
                break;
            }
            case "idlersc": 
            case "IdleRSC": {
                icon = "idlersc-large";
                break;
            }
            case "winrune": 
            case "WinRune": {
                icon = "rune-large";
                break;
            }
            case "mudclient38": 
            case "Mudclient 38": {
                icon = "mudclient38-large";
                break;
            }
            case "rsctimes": 
            case "RSCx": {
                icon = "rsctimes-large";
                break;
            }
            case "webclient": 
            case "Web Client": {
                icon = "webbrowser-large";
                break;
            }
            default: {
                icon = "question_mark-small";
            }
        }
        return new LinkButton(icon, new Rectangle(10, 120, 120, 120));
    }

    private static int makeCheckboxLabel(String text, int x, int y, JLabel POPUP_BACKGROUND) {
        JLabel undecoratedLabel = new JLabel(text);
        undecoratedLabel.setFont(MainWindow.helvetica13);
        undecoratedLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        int undecoratedLabelHeight = undecoratedLabel.getFontMetrics(MainWindow.helvetica13).getHeight();
        undecoratedLabel.setBounds(x, y, undecoratedLabel.getPreferredSize().width, undecoratedLabelHeight);
        undecoratedLabel.setForeground(MainWindow.white);
        POPUP_BACKGROUND.add(undecoratedLabel);
        return undecoratedLabel.getPreferredSize().width;
    }

    static {
        preservationSettingsCard = new ClientSettingsCard();
        cabbageSettingsCard = new ClientSettingsCard();
        O1scapeSettingsCard = new ClientSettingsCard();
        openpkSettingsCard = new ClientSettingsCard();
        uraniumSettingsCard = new ClientSettingsCard();
        coleslawSettingsCard = new ClientSettingsCard();
    }
}

