/*
 * Decompiled with CFR 0.152.
 */
package launcher.popup;

import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import launcher.Fancy.MainWindow;

public class SavedIndicatorThread
implements Runnable {
    private final int animationFrame;
    private final JLabel POPUP_BACKGROUND;
    private JLabel savedText;

    public SavedIndicatorThread(int animationFrame, JLabel POPUP_BACKGROUND) {
        this.animationFrame = animationFrame;
        this.POPUP_BACKGROUND = POPUP_BACKGROUND;
    }

    @Override
    public void run() {
        this.drawLabel(this.animationFrame);
    }

    public void drawLabel(int animationFrame) {
        if (null != this.savedText) {
            this.POPUP_BACKGROUND.remove(this.savedText);
        } else {
            this.savedText = new JLabel("Saved!");
            this.savedText.setFont(MainWindow.helvetica36);
            this.savedText.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
        if (animationFrame >= 0) {
            this.savedText.setBounds(300, 260 + animationFrame, this.savedText.getPreferredSize().width, this.savedText.getFontMetrics(MainWindow.helvetica36).getHeight());
            int gray = (int)((double)animationFrame * 2.5);
            this.savedText.setForeground(new Color(gray, gray, gray));
            this.POPUP_BACKGROUND.add(this.savedText);
            this.POPUP_BACKGROUND.repaint();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.drawLabel(--animationFrame);
        } else {
            this.savedText.setVisible(false);
            this.POPUP_BACKGROUND.remove(this.savedText);
            this.POPUP_BACKGROUND.repaint();
        }
    }

    public JLabel getSavedText() {
        return this.savedText;
    }
}

